/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.passwordprotect.commands;

import de.dustplanet.passwordprotect.PasswordProtect;
import de.dustplanet.passwordprotect.jail.JailHelper;
import de.dustplanet.passwordprotect.jail.JailLocation;
import de.dustplanet.passwordprotect.utils.PasswordProtectUtilities;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@SuppressFBWarnings(value={"IMC_IMMATURE_CLASS_NO_TOSTRING"})
public class PasswordProtectSetJailLocationCommand
implements CommandExecutor {
    private static final int DEFAULT_RADIUS = 4;
    private final PasswordProtect plugin;
    private final PasswordProtectUtilities utils;
    private final JailHelper jailHelper;

    public PasswordProtectSetJailLocationCommand(PasswordProtect instance, JailHelper jailHelper) {
        this.plugin = instance;
        this.utils = instance.getUtils();
        this.jailHelper = jailHelper;
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            String messageLocalization;
            Player player = (Player)sender;
            if (!player.hasPermission("passwordprotect.setjailarea")) {
                String messageLocalization2 = this.plugin.getLocalization().getString("permission_denied");
                this.utils.message((CommandSender)player, messageLocalization2, null);
                return true;
            }
            World world = player.getWorld();
            int radius = 4;
            if (args.length >= 1) {
                try {
                    radius = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    messageLocalization = this.plugin.getLocalization().getString("radius_not_number");
                    this.utils.message((CommandSender)player, messageLocalization, null);
                    radius = 4;
                }
            }
            JailLocation loc = new JailLocation(player.getLocation(), radius);
            this.jailHelper.setJailLocation(world, loc);
            messageLocalization = this.plugin.getLocalization().getString("jail_set");
            this.utils.message((CommandSender)player, messageLocalization, null);
        } else {
            String messageLocalization = this.plugin.getLocalization().getString("only_ingame");
            this.utils.message(sender, messageLocalization, null);
        }
        return true;
    }
}

